# app.py

import boto3
from boto3.dynamodb.conditions import Key, Attr
import os

from flask import Flask, jsonify, request
from flask_httpauth import HTTPBasicAuth
from flask import g

auth = HTTPBasicAuth()
app = Flask(__name__)

dynamodb = boto3.resource('dynamodb')

@app.route("/")
def hello():
    print("action=hello method=GET path=/")
    return "hello"

@app.route("/public_notes")
def get_notes():
    tableName = get_table('Notes')
    if not tableName == "error":
        print("action=get_public_notes method=GET path=/public_notes")
        table = dynamodb.Table(tableName)
        resp = table.scan(FilterExpression=Attr('IsPublic').eq('1'))
        items = resp['Items']
        return jsonify({
            'Notes': items
        })
    else:
        print("action=get_public_notes method=GET path=/public_notes error=can not find dynamodb table")
        return jsonify({
            'Error': 'cannot find DynamoDB table'
        })

@app.route("/notes")
@auth.login_required
def get_private_notes():
    tableName = get_table('Notes')
    if not tableName == "error":
        print("action=get_private_notes method=GET path=/notes user=" + g.user['UserName'])
        table = dynamodb.Table(tableName)
        resp = table.scan(
            FilterExpression=Key('UserName').eq(g.user['UserName'])
        )
        items = resp['Items']
        return jsonify({
            'Notes': items
        })
    else:
        print("action=get_public_notes method=GET path=/public_notes error=can not find dynamodb table")
        return jsonify({
            'Error': 'cannot find DynamoDB table'
        })


@auth.verify_password
def verify_password(username, password):
    tableName = get_table('Users')
    table = dynamodb.Table(tableName)
    if not table == "error":
        resp = table.query(
            KeyConditionExpression=Key('UserName').eq(username)
        )
        items = resp['Items']
        if len(items)>0 and str(password).strip()==str(items[0]['Password']).strip():
            g.user = items[0]
            print("action=authentication result=success method=GET user=" + username)
            return True

        print("action=authentication result=failure method=GET user=" + username)
        return False
    else:
        print("action=authentication result=failure method=GET user=" + username + " error=cannot find DynamoDB table")
        return False


def get_table(str):
    client = boto3.client('dynamodb')
    response = client.list_tables()
    for tableName in response['TableNames']:
        if tableName.startswith(str):
            return tableName
    return 'error'
